#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

void DFS(int root, vector<int> PB[], int d[], bool visited[], int parent[]) {
    for(int i = 0; i < PB[root].size(); i++){
        int u = PB[root].at(i);
        if(!visited[u]) {
            d[u] = d[root] + 1;
            parent[u] = root;
            visited[u] = true;
            DFS(u, PB, d, visited, parent);
        }
    }
}

int LCA(int u, int v, int d[], int parent[], int **lcas, bool **visitedLcas) {
    int lca;
    if (visitedLcas[u][v]) lca = lcas[u][v];
    else {
        if(d[v] > d[u]) swap(u, v);
        if(d[u] > d[v]) lca = LCA(parent[u], v, d, parent, lcas, visitedLcas);
        else if (u != v) lca = LCA(parent[u], parent[v], d, parent, lcas, visitedLcas);
        else lca = u;

        visitedLcas[u][v] = true;
        visitedLcas[v][u] = true;
        lcas[u][v] = lca;
        lcas[v][u] = lca;
    }
    return lca;
}

int main()
{
    int N, Q;
    cin >> N;
    int order[N];
    vector<int> PB[N] = {};
    int d[N];
    d[0] = 0;
    bool visited[N] = {};
    visited[0] = true;
    int parent[N];
    parent[0] = 0;
    int **lcas;
    bool **visitedLcas;
    lcas = new int *[N];
    visitedLcas = new bool *[N];
    for(int i = 0; i < N; i++){
        lcas[i] = new int[N];
        visitedLcas[i] = new bool [N];
        for(int y = 0; y < N; y++) visitedLcas[i][y] = false;
    }

    for(int i = 0; i < N; i++){
        int x;
        cin >> x;
        order[i] = x-1;
    }

    for(int i = 0; i < N-1; i++){
        int u, v;
        cin >> u >> v;
        PB[u-1].push_back(v-1);
        PB[v-1].push_back(u-1);
    }
    DFS(0, PB, d, visited, parent);
    cin >> Q;
    for(int i = 0; i < Q; i++){
        int comm;
        cin >> comm;
        if(comm == 1) {
            int a, b;
            cin >> a >> b;
            a--;
            b--;
            swap(order[a], order[b]);
        }
        else {
            int l, r, x;
            cin >> l >> r >> x;
            int maxDist = 0;
            x--;
            r--;
            l--;
            for(int y = l; y <= r; y++) {
                int lca = LCA(x, order[y], d, parent, lcas, visitedLcas);
                int dist = d[x] + d[order[y]] - 2 * d[lca];
                if(dist > maxDist) maxDist = dist;
            }
            cout << maxDist << endl;
        }
    }
}